/************************************************************************
 * @file: Events.h
 *
 * @version: 1.0
 *
 * @description: Events module declares context for each epoll event.
 * Entry functions for all events received by epoll_wait().
 * Event class further creates the WorkItems for processing of
 * occurred events.
 *
 * @component: platform/ipod
 *
 * @author: Dhanasekaran Devarasu, Dhanasekaran.D@in.bosch.com 2017
 *
 * @copyright (c) 2017 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * @see <related items>
 *
 * @history
 *
 ***********************************************************************/

#ifndef EVENTS_H_
#define EVENTS_H_

#include <iap2_init_private.h>
#include <iap2_service_init.h>
#include <memory>

namespace adit { namespace iap2service {

class Event
{
public:
    Event();
    Event(int32_t fd) : mFd(fd){}
    virtual ~Event(){}
    virtual int process(int32_t events) = 0;
    int getFd() { return mFd;}
protected:
    int mFd;
};

class ServerEvent : public Event
{
public:
    ServerEvent();
    ~ServerEvent(){}
    ServerEvent(int32_t fd) : Event(fd){}
    int process(int32_t events) override;
};

class ClientEvent : public Event
{
public:
    ClientEvent();
    ~ClientEvent(){}
    ClientEvent(int32_t fd, int32_t clientId) : Event(fd), mClientId(clientId){}
    int process(int32_t events) override;
private:
    int mClientId;
};

class DeviceEvent : public Event
{
public:
    DeviceEvent();
    ~DeviceEvent(){}
    DeviceEvent(int32_t fd, std::shared_ptr<iAP2Device_st> device) : Event(fd), mDevice(device) {}
    int process(int32_t events) override;
private:
    std::shared_ptr<iAP2Device_st> mDevice;
};

class ShutdownEvent: public Event
{
public:
    ShutdownEvent();
    ~ShutdownEvent(){}
    ShutdownEvent(int fd) : Event(fd){}
    int process(int32_t events) override;
};

class ThreadFreeEvent: public Event
{
public:
    ThreadFreeEvent();
    ~ThreadFreeEvent(){}
    ThreadFreeEvent(int fd) : Event(fd){}
    int process(int32_t events) override;
};

} } //namespace adit { namespace iap2service {

#endif /* EVENTS_H_ */
